;----------------------------------------------------------------------------
; Sega Naomi
; Demul .56  
; by BBB
; 1.0
;
; Notes:
;
;----------------------------------------------------------------------------

;Settings
loadingScreen=1
fullscreenWidth = 1024
fullscreenHeight = 768


if(loadingScreen){
  Gui +AlwaysOnTop -Caption +ToolWindow 
  Gui, Color, White
  logoXPos := A_ScreenWidth/2 - 600 /2
  Gui, Add, Picture,x%logoXPos% y120, %A_ScriptDir%\Modules\Sega Naomi\Logo.png
  loadXPos := A_ScreenWidth/2 - 230 /2
  loadYPos := A_ScreenHeight - 100
  Gui, Add, Picture,x%loadXPos% y%loadYPos%, %A_ScriptDir%\Modules\Sega Naomi\Loading.png
  Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%
}

setRoms()

currentName := %RomName%.name
currentControls := %RomName%.controls

settingsFile = %emupath%Demul.ini
padFile = %emupath%padDemul.ini

;This part might need some work since I havent familiarized myself with all the control possibilities
if(currentControls = "lightgun" || currentControls = "mouse"){
  IniWrite, 131072, %settingsFile%, PORTB, device
  IniWrite, standard, %padFile%, CONTROL_TYPE, CONTROL_TYPE
}else if(currentControls = "keyboard"){
  IniWrite, 1073741824, %settingsFile%, PORTB, device
  IniWrite, keybaord, %padFile%, CONTROL_TYPE, CONTROL_TYPE
}else{
  IniWrite, 16777216, %settingsFile%, PORTB, device
  IniWrite, currentControls, %padFile%, CONTROL_TYPE, CONTROL_TYPE
}
	
if(currentControls = "standard" || currentControls = "lightgun"){
  WriteStandardControls()
}
else if(currentControls = "ggxstyle"){
  WriteGGXControls()
}
else if(currentControls = "sfstyle"){
  WriteSFStyleControls() 
}
else if(currentControls = "lightgun"){
  WriteStandardControls()
}  
else if(currentControls = "driving"){
  WriteDrivingControls()  
}else{
  WriteStandardControls()
}

WriteStandardControls(){
  IniWrite, 200, %padFile%, ATOMISWAVE0_0, UP
  IniWrite, 208, %padFile%, ATOMISWAVE0_0, DOWN
  IniWrite, 203, %padFile%, ATOMISWAVE0_0, LEFT
  IniWrite, 205, %padFile%, ATOMISWAVE0_0, RIGHT
  IniWrite, 46,  %padFile%, ATOMISWAVE0_0, SHOT1
  IniWrite, 18,  %padFile%, ATOMISWAVE0_0, SHOT2
  IniWrite, 44,  %padFile%, ATOMISWAVE0_0, SHOT3
  IniWrite, 45,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 21,  %padFile%, ATOMISWAVE0_0, SHOT5
  IniWrite, 38,  %padFile%, ATOMISWAVE0_0, START
  IniWrite, 39,  %padFile%, ATOMISWAVE0_0, COIN

  IniWrite, 72, %padFile%, ATOMISWAVE0_1, UP
  IniWrite, 76, %padFile%, ATOMISWAVE0_1, DOWN
  IniWrite, 75, %padFile%, ATOMISWAVE0_1, LEFT
  IniWrite, 77, %padFile%, ATOMISWAVE0_1, RIGHT
  IniWrite, 50, %padFile%, ATOMISWAVE0_1, SHOT1
  IniWrite, 47, %padFile%, ATOMISWAVE0_1, SHOT2
  IniWrite, 48, %padFile%, ATOMISWAVE0_1, SHOT3
  IniWrite, 45, %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 25, %padFile%, ATOMISWAVE0_1, SHOT5
  IniWrite, 19, %padFile%, ATOMISWAVE0_1, START
  IniWrite, 51, %padFile%, ATOMISWAVE0_1, COIN
}

WriteGGXControls(){
  IniWrite, 18,  %padFile%, ATOMISWAVE0_0, SHOT2
  IniWrite, 44,  %padFile%, ATOMISWAVE0_0, SHOT3
  IniWrite, 20,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 21,  %padFile%, ATOMISWAVE0_0, SHOT5
  
  IniWrite, 47, %padFile%, ATOMISWAVE0_1, SHOT2
  IniWrite, 48, %padFile%, ATOMISWAVE0_1, SHOT3
  IniWrite, 24, %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 25, %padFile%, ATOMISWAVE0_1, SHOT5
}

WriteSFStyleControls(){
  IniWrite, 45,  %padFile%, ATOMISWAVE0_0, SHOT2
  IniWrite, 21,  %padFile%, ATOMISWAVE0_0, SHOT3
  IniWrite, 18,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 44,  %padFile%, ATOMISWAVE0_0, SHOT5
  
  IniWrite, 49, %padFile%, ATOMISWAVE0_1, SHOT2
  IniWrite, 25, %padFile%, ATOMISWAVE0_1, SHOT3
  IniWrite, 47,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 48, %padFile%, ATOMISWAVE0_1, SHOT5 
}

WriteDrivingControls(){
  IniWrite, 45,  %padFile%, ATOMISWAVE0_0, SHOT2
  IniWrite, 21,  %padFile%, ATOMISWAVE0_0, SHOT3
  IniWrite, 18,  %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 44,  %padFile%, ATOMISWAVE0_0, SHOT5
  
  IniWrite, 47, %padFile%, ATOMISWAVE0_1, SHOT2
  IniWrite, 48, %padFile%, ATOMISWAVE0_1, SHOT3
  IniWrite, 24, %padFile%, ATOMISWAVE0_0, SHOT4
  IniWrite, 25, %padFile%, ATOMISWAVE0_1, SHOT5
}

IniWrite, %fullscreenWidth%, %emupath%gpuOglv3.ini, resolution, fWidth
IniWrite, %fullscreenHeight%, %emupath%gpuOglv3.ini, resolution, fHeight
Run, "%Emupath%%Executable%" -run=naomi -rom=%RomName%
SetTimer, CheckWin, 2

sizeOrg=
CheckWin:
IfWinNotExist, ahk_class window
{
   return
}else{
   WinGetPos,,,W,,ahk_class window
   if(W != sizeOrg && sizeOrg != ""){
      Goto StartGame
   }else{
      sizeOrg = %W%
   }
}
return

StartGame:
  SetTimer, CheckWin, Off
  WinActivate ahk_class window
  Send !{ENTER}
  Gui Destroy
  Process, WaitClose, %executable%
return
           
CloseProcess:
  Process, Close, %executable%
  ExitApp  
return

setRoms(){
  ;NAOMI
  18wheelr := Object("name", "18 Wheeler - American Pro Trucker", "controls", "driving")
  akatsukibk := Object("name", "Akatsuki Bk Ausf Achse", "controls", "standard")
  alpiltdx := Object("name", "Airline Pilots Deluxe (Rev. B)", "controls", "driving")
  alpilota := Object("name", "Airline Pilots (Rev. A)", "controls", "driving")
  azumanga := Object("name", "Azumanga Daioh Puzzle Bobble", "controls", "standard")
  capsnk := Object("name", "Capcom Vs. SNK Millennium Fight 2000 (904)", "controls", "sfstyle")
  capsnka := Object("name", "Capcom Vs. SNK Millennium Fight 2000 (804)", "controls", "sfstyle")
  crackndj := Object("name", "Crack'n DJ", "controls", "standard")
  crzytaxi := Object("name", "Crazy Taxi", "controls", "driving")
  csmash := Object("name", "Cosmic Smash (rev.A)", "controls", "standard")
  csmasho := Object("name", "Cosmic Smash (original)", "controls", "standard")
  cspike := Object("name", "Gun Spike (Japan)", "controls", "reverse")
  deathcox := Object("name", "Death Crimson OX", "controls", "lightgun")
  derbyoc := Object("name", "Derby Owners Club", "controls", "standard")
  derbyocw := Object("name", "Derby Owners Club World Edition (Rev. C)", "controls", "standard")
  derbyoc2 := Object("name", "Derby Owners Club II", "controls", "standard")
  doa2 := Object("name", "Dead or Alive 2", "controls", "standard")
  doa2m := Object("name", "Dead or Alive 2 Millenium", "controls", "standard")
  dybb99 := Object("name", "Worls Series '99 / Dynamite Baseball '99", "controls", "standard")
  dybbnao := Object("name", "Dynamite Basball naomi (JPN)", "controls", "standard")
  f355 := Object("name", "Ferrari F355 Challenge", "controls", "driving")
  f355twin := Object("name", "Ferrari F355 Challenge (Twin) ", "controls", "driving")
  f355twin2 := Object("name", "Ferrari F355 Challenge 2 (Twin)", "controls", "driving")
  ggram2 := Object("name", "Giant Gram", "controls", "standard")
  ggx := Object("name", "Guilty Gear X (JPN)", "controls", "ggxstyle")
  gram2000 := Object("name", "Giant Gram 2000", "controls", "standard")
  gunsur2 := Object("name", "Gun Survivor 2-Bio Hazard Code Veronica", "controls", "fps")
  gwing2 := Object("name", "Giga Wing 2", "controls", "standard")
  hmgeo := Object("name", "Heavy Metal Geomatrix", "controls", "standard")
  hotd2 := Object("name", "House of the Dead 2", "controls", "lightgun")
  hotd2o := Object("name", "House of the Dead 2 (Original)", "controls", "lightgun")
  jambo := Object("name", "Jambo! Safari (Rev. A)", "controls", "jambodriving")
  kick4csh := Object("name", "Kick '4' Cash", "controls", "standard")
  mvsc2 := Object("name", "Marvel vs. Capcom 2", "controls", "sfstyle")
  otrigger := Object("name", "OutTrigger", "controls", "standard")
  pjustic := Object("name", "Project Justice /Moeru Justice Gakuen", "controls", "sfstyle")
  pstone := Object("name", "Powerstone", "controls", "standard")
  pstone2 := Object("name", "Powerstone 2", "controls", "standard")
  qmegamis := Object("name", "Quiz Ah Megamisama", "controls", "standard")
  samba := Object("name", "Samba De Amigo (Rev. B)", "controls", "samba")
  sgtetris := Object("name", "Sega Tetris", "controls", "standard")
  shangril := Object("name", "Dengen Tenshi Taisen Janshi Shangri-la", "controls", "keyboard")
  shootpl := Object("name", "Shootout Pool / Shootout Pool Prize", "controls", "standard")
  shootopl := Object("name", "Shootout Pool", "controls", "standard")
  shtnglv2k7 := Object("name", "Shooting Love 2007", "controls", "standard")
  slasho := Object("name", "Slashout", "controls", "standard")
  smarinef := Object("name", "Sega Marine Fishing", "controls", "standard")
  smlg99 := Object("name", "Super Major League '99", "controls", "standard")
  spawn := Object("name", "Spawn - In the Demon's Hand", "controls", "standard")
  sstrkfgt := Object("name", "Sega Strike Fighter (Rev. A)", "controls", "standard")
  suchie3 := Object("name", "Idol Janshi Suchie-Pai 3", "controls", "keyboard")
  totd := Object("name", "The Typing of the Dead", "controls", "keyboard")
  toyfight := Object("name", "Toy Fighter", "controls", "standard")
  virnba := Object("name", "Virtua NBA", "controls", "standard")
  virnbao := Object("name", "Virtua NBA (original)", "controls", "standard")
  vs2_2k := Object("name", "Virtua Striker 2 Ver.2000", "controls", "standard")
  vtennis := Object("name", "Virtua Tennis / Power Smash", "controls", "standard")
  vtenis2c := Object("name", "Virtua Tennes 2 / Power Smash", "controls", "standard")
  wwfroyal := Object("name", "WWF Royal Rumble", "controls", "standard")
  zombrvn := Object("name", "Zombie Revenge", "controls", "standard")
  
  ;Naomi GD Rom
  azumanga := Object("name", "Azumanga Daioh Puzzle Bobble (GDL-0018)", "controls", "standard")
  bdrdown := Object("name", "Border Down (Rev A) (GDL-0023-A)", "controls", "standard")
  cfield := Object("name", "Chaos Field (GDL-0025)", "controls", "standard")
  chocomk := Object("name", "Musapey's Choco Maker (Rev. A) (GDL-0014A)", "controls", "standard")
  cleoftp := Object("name", "Cleopatra Fortune Plus (GDL-0012)", "controls", "standard")
  confmiss := Object("name", "Confidential Mission (GDS-0001)", "controls", "lightgun")
  cvs2gd := Object("name", "Capcom vs SNK 2 Millionaire Fighting 2001 (Rev A) (GDL-0007A)", "controls", "sfstyle")
  cvsgd := Object("name", "Capcom vs SNK 2 Millionaire Fighting 2000 Pro (GDL-0004)", "controls", "sfstyle")
  dygolf := Object("name", "Virtua Golf \ Dynamic Golf (GDA-0009)", "controls", "mouse")
  ggxx := Object("name", "Guilty Gear XX (GDL-0011)", "controls", "ggxstyle")
  ggxxac := Object("name", "Guilty Gear Accent Core (GDL-041) ", "controls", "ggxstyle")
  ggxxrl := Object("name", "Guilty Gear XX #Reload (Rev A) (GDL-0019A)", "controls", "ggxstyle")
  ggxxsla := Object("name", "Guilty Gear XX Slash (Rev A) (GDL-0033A)", "controls", "ggxstyle")
  gundmgd := Object("name", "Mobile Suit Gundam: Federation VS Zeon (GDL-001)", "controls", "standard")
  gundmxgd := Object("name", "Mobile Suit Gundam: Federation VS Zeon DX (GDL-0006)", "controls", "standard")
  ikaruga := Object("name", "Ikaruga (GDL-0010)", "controls", "standard")
  jingystm := Object("name", "Jingi Storm - The Arcade (GDL-0037)", "controls", "standard")
  karous := Object("name", "Karous (GDL-0040)", "controls", "standard")
  keyboard := Object("name", "La Keyboard (GDS-0017)", "controls", "keyboard")
  kurucham := Object("name", "Kurukuru Chameleon (GDL-0034)", "controls", "standard")
  lupinsho := Object("name", "Lupin the Third - The Shooting (GDS-0018)", "controls", "lightgun")
  luptype := Object("name", "Lupin the Third - The Typing (Rev A) (GDS-0021A)", "controls", "keyboard")
  mamonoro := Object("name", "Mamonoro", "controls", "standard")
  meltyb := Object("name", "Melty Blood Act Cadenza Ver B (GDL-0039)", "controls", "ggxstyle")
  meltyba := Object("name", "Melty Blood Act Cadenza Ver B (Rev A) (GDL-0039A)", "controls", "ggxstyle")
  meltybld := Object("name", "Melty Blood Act Cadenza Ver B (Rev C) (GDL-0028C)", "controls", "ggxstyle")
  moeru := Object("name", "Burning Casino / Moery Casinyo (GDL-0013)", "controls", "standard")
  mok := Object("name", "The Maze of Kings (GDS-0022)", "controls", "lightgun")
  monkeyba := Object("name", "Monkey Ball (GDS-0008)", "controls", "standard")
  ngdup23a := Object("name", "naomi Dimm Firmware Updater (GDL-0023A)", "controls", "standard")
  ngdup23c := Object("name", "naomi Dimm Firmware Updater (GDL-0023C)", "controls", "standard")
  psyvar2 := Object("name", "Psyvariar 2 - The will to Fabricate (GDL-0024)", "controls", "standard")
  puyofev := Object("name", "Puyo Puyo Fever (GDS-0031)", "controls", "standard")
  quizgd := Object("name", "Quiz Ketai Q mode (GDL-0017)", "controls", "standard")
  radirgy := Object("name", "Radirgy (GDL-0032)", "controls", "standard")
  radirgynoa := Object("name", "Radirgy Noir", "controls", "standard")
  senko := Object("name", "Senko No Ronde New ver. (Rev A) (GDL-0030A)", "controls", "standard")
  senkoo := Object("name", "Senko No Ronde (original) (GDL-0030)", "controls", "standard")
  senkosp := Object("name", "Senko No Ronde Speacial (GDL-0038)", "controls", "standard")
  sfz3ugd := Object("name", "Street Fighter Zero 3 Upper (GDL-0002)", "controls", "sfstyle")
  shikgam2 := Object("name", "Then Castle of Ahikigami II / Shikagami No Shiro II (GDL-0021)", "controls", "standard")
  slashout := Object("name", "Slashout (GDS-0004)", "controls", "standard")
  spkrbtl := Object("name", "Spikers Battle (GDS-0005)", "controls", "standard")
  sprtjam := Object("name", "Sports Jam (GDS-0003)", "controls", "standard")
  ss2005 := Object("name", "Super Shanghai 2005 (GDL-0031)", "controls", "standard")
  ss2005a := Object("name", "Super Shanghai 2005 (Rev. A) (GDL-0031A)", "controls", "standard")
  starseek := Object("name", "Doki Doki Star Seeker (GDL-0005)", "controls", "standard")
  takoron := Object("name", "Noukone Puzzle Takoron (GDL-0042)", "controls", "standard")
  tetkiwam := Object("name", "Tetris Kiwamemichi (GDL-0020)", "controls", "standard")
  trgheart := Object("name", "Trigger Heart Excelica (Rev A) (GDL-0036A)", "controls", "standard")
  trizeal := Object("name", "Trizeal (GDL-0026)", "controls", "standard")
  undefeat := Object("name", "Under Defeat (GDL-0035)", "controls", "standard")
  usagui := Object("name", "Usagi - Yamashiro Mahjong Hen (GDL-0022)", "controls", "keyboard")
  vathlete := Object("name", "Virtua Atheletics / Virtua Athlete (GDS-0019)", "controls", "standard")
  vtennis2 := Object("name", "Virtua Tennis 2 / Power Smash 2 (Rev A) (GDS-0015A)", "controls", "standard")
  vtennisg := Object("name", "Virtua Tennis (GDS-0011)", "controls", "standard")
  wsbbgd := Object("name", "World Series Basball / Super Major League (GDS-0010)", "controls", "standard")
  
  ;Naomi 2
  clubkrte := Object("name", "Club Kart - European Session (Cart)", "controls", "driving")
  vf4cart := Object("name", "Virtua Fighter 4 (Cart)", "controls", "standard")
  vf4evoct := Object("name", "Virtua Fighter 4 Evolution (Cart)", "controls", "standard")
  vstrike3c := Object("name", "Virtua Striker 3 (Cart)", "controls", "standard")
  wldrider := Object("name", "Wild Riders (Cart)", "controls", "driving")
  
  ;Naomi 2 GD Rom
  beachspi := Object("name", "Beach Spikers (gds-0014)", "controls", "standard")
  initd := Object("name", "Initial D Arcade Stage (Rev B) (GDS-0020B)", "controls", "driving")
  initdexp := Object("name", "Initial D Arcade Stage (Export) (GDS-0025)", "controls", "driving")
  initdv2j := Object("name", "Initial D Arcade Stage Ver.2 (GDS-0026)", "controls", "driving")
  initdv3j := Object("name", "Initial D Arcade Stage Ver.3 (GDS-0032B)", "controls", "driving")
  vf4 := Object("name", "Virtua Fighter 4 (GDS-0012)", "controls", "standard")
  vf4b := Object("name", "Virtua Fighter 4 (Rev B) (GDS-0012B)", "controls", "standard")
  vf4c := Object("name", "Virtua Fighter 4 (Rev C) (GDS-0012C)", "controls", "standard")
  vf4evo := Object("name", "Virtua Fighter 4 Evolution (Rev B) (GDS-0024B)", "controls", "standard")
  vf4evoa := Object("name", "Virtua Fighter 4 Evolution (Rev A) (GDS-0024A)", "controls", "standard")
  vf4tuned := Object("name", "Virtua Fighter 4 Final Tuned (Rev B) (GDS-0036F)", "controls", "standard")
  vf4tuneda := Object("name", "Virtua Fighter 4 Final Tuned (Rev A) (GDS-0036A)", "controls", "standard")
  vf4tunedd := Object("name", "Virtua Fighter 4 Final Tuned (Rev D) (GDS-0036D)", "controls", "standard")
  vstrik3 := Object("name", "Virtua Striker 3 (GDS-0006)", "controls", "standard")
  vstrik3c := Object("name", "Virtua Striker 3 (cart)", "controls", "standard")
}